# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Parse/Lex.pm) perl(Parse/Yapp/Driver.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 0.5
%define module_name Config-Objective
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.5
Release: alt1
Summary: Perl module for parsing object-oriented config files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RO/ROTH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The Config::Objective module provides a mechanism for parsing
config files to manipulate configuration data.  Unlike most other
config file modules, which represent config data as simple variables,
Config::Objective represents config data as perl objects.  This allows
for a much more flexible configuration language, since new classes can
be easily written to add methods to the config syntax.

The Config::Objective class supports the following methods:

=over 4

=item new()

The constructor.  The first argument is the filename of the config file
to parse.  The second argument is a reference to a hash that maps names 
to configuration objects.

The remaining arguments are interpretted as a hash of attributes for
the object.  Currently, the only supported attribute is *include_dir*,
which specifies the directory to search for include files (see the File Inclusion entry elsewhere in this document).  If not specified, *include_dir* defaults to ".".

=item *object_name*

Once the constructor parses the config file, you can call the get()
method of any of the objects by using the object name as an autoloaded
method (see the Recommended Methods entry elsewhere in this document).

=item get_obj()

Returns a reference to the object of the specified object name.  The
object name is the first argument.

=item obj_names()

Returns a list of known object names.

=item get_hash()

Returns a hash where the keys are the known object names and the values
are the result of calling the get() method on the corresponding object.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT ChangeLog README TODO
%perl_vendor_privlib/C*

%changelog
