%define module_name Config-Parser
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Config/AST.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(Module/Metadata.pm) perl(Text/Locus.pm) perl(Text/ParseWords.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.05
Release: alt1
Summary: base class for configuration file parsers
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SG/SGRAY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Config::Parser provides a framework for writing configuration file
parsers.  It is an intermediate layer between the abstract syntax tree
(Config::AST) and implementation of a parser for a particular
configuration file format.

It takes a *define by example* approach.  That means that the implementer
creates a derived class that implements a parser on top of Config::Parser.
Application writers write an example of configuration file in the __DATA__
section of their application, which defines the statements that are allowed
in a valid configuration.  This example is then processed by the parser
implementation to create an instance of the parser, which is then used to
process the actual configuration file.

Let's illustrate this on a practical example.  Suppose you need a parser for
a simple configuration file, which consists of keyword/value pairs.  In each
pair, the keyword is separated from the value by an equals sign.  Pairs are
delimited by newlines.  Leading and trailing whitespace characters on a line
are ignored as well as are empty lines.  Comments begin with a hash sign and
end with a newline.

You create the class, say Config::Parser::KV, inherited from
Config::Parser.  The method parser in this class implements the actual
parser.

Application writer decides what keywords are allowed in a valid configuration
file and what are their values and describes them in the __DATA__ section
of his program (normally in a class derived from Config::Parser::KV, in
the same format as the actual configuration file.  For example:

  __DATA__
  basedir = STRING :mandatory
  mode = OCTAL
  size = NUMBER :array

This excerpt defines a configuration with three allowed statements.  Uppercase
values to the right of the equals sign are data types.  Values starting with
a colon are flags that define the semantics of the values.  This section
declares that three keywords are allowed.  The basedir keyword takes
string as its argument and must be present in a valid configuration.  The
mode expects octal number as its argume...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/C*

%changelog
