# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Log/Log4perl.pm) perl(MIME/Base64.pm) perl(Pod/Usage.pm) perl(Set/IntSpan.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name Config-Patch
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Patch configuration files and unpatch them later
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MS/MSCHILLI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Config::Patch provides an interface to modify configuration files
in a way so that the changes can be rolled back later on.
For example, let's say that an application wants to append the line

    joeschmoe ALL= NOPASSWD:/etc/rc.d/init.d/myapp

at the end of the /etc/sudoers file to allow user joeschmoe to start and 
stop the myapp application as root without having to type a password.

Normally, you'd have to do this by hand or via an installation script.
And later on, when myapp gets ejected from the system,
you'd have to remember to delete the line from /etc/sudoers as well.

Config::Patch provides an automated way to apply this 'patch' to the
configuration file and to detect and eject it later on. It does this
by placing special markers around the insertion, without having to refer
to any external meta data.

Note that a 'patch'
in this context is just a snippet of text that's to be applied somewhere
within the file (not to be confused with the diff-formatted text used 
by the `patch' Unix utility).
Patches are line-based, `Config::Patch' always adds/removes entire lines.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
