# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/Find.pm) perl(Config/Properties.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.14
%define module_name Config-Properties-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.14
Release: alt1
Summary: Perl extension to manage configuration files.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SALVA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This package mix functionality in the Config::Properties manpage and.the Config::Find manpage packages to provide a simple access to
configuration files.

It changes `new' and `save' methods of the Config::Properties manpage (every
other method continues to work as usual):

=over 4

=item Config::Properties::Simple->new(%%opts)

creates a new the Config::Properties::Simple manpage object and reads on the
configuration file determined by the options passed through `%%opts'.

The supported options are:

=over 4

=item `defaults => {...}'

hash reference containing default values for the configuration keys
(similar to `defaultProperties' field in the original
`Config::Properties::new' constructor).

=item `noread => 1'

=item `mode => "write"'

stops properties for being read from a file.

=item `utf8 ='> 1>

opens the file for reading/writing with the `:utf8' layer.

=item `optional => 1'

by default an exception is thrown when the configuration file can not
be found or opened, this option makes the constructor succeed anyway.

If the `file' option is included and defined the constructor dies
unless `optional' value is greater than 1. This is useful to let the
user pass the configuration file name on the script command line when
you want the script to fail if it's not found.

=item `format => $format'

equivalent to calling `setFormat' method.

=item `dups_ok => 1'

by default, an error is reported when two similar keys are found on
the same file, setting dups_ok causes previous values to be ignored
instead.

=item `aliases => { alias1 =' key1, alias2 =>key2 ... }

entries on the configuration file whose keys are found on the aliases
hash are normalized to the corresponding key. Aliases only affect
parsing and are not taken into account for default values or when
getting or setting properties.

=item `validate => ...'

sets conditions that the properties in the configuration file have to
meet.

There are several formats allowed:

=over 4

=item `validate => \&subroutine'

calls the subroutine as

  &subroutine($key, $value, $cfg)

subroutine should return a true value if the pair `$key' `$value' is
valid or false otherwise. For customized error messages
`$cfg->fail($error)' can be called.

Both `$key' and `$value' can be modified manipulating the `@_'
array directly. Its sometimes useful to normalize the value, i.e.:

  use Date::Manip;
  sub validate_date { defined($_[1] = Date::Manip::ParseDate($_[1])) }
  my $cfg = Config::Properties::Simple->new(validate => \&validate_date);


=item `validate => \@array'

only properties in `@array' are allowed. Regexp are also allowed
inside de array. i.e.:

   validate => [ qr/^Foo\.\w+$/, qw(Bar Doz) ],


=item `validate => \%%hash'

`%%hash' allows to set a condition for every property.

There could be an additional `__default' entry to be applied to
properties that don't have their own entries.

Supported conditions are:

=over 4

=item `\&subroutine'

calls the subroutine as

  &subroutine($key, $value, $cfg)

similar to passing a validating subrutine (explained before).

=item `\@array'

property value has to be in `@array'.

=item `\%%hash'

`$hash{$value}' has to exist and its value is returned instead of the
original `$value'.

=item `qr/regular expression/'

`$value' has to match the regular expression.

=item `b' or `boolean'

`$value' has to be a boolean value.

Valid true values are `y', `yes', `t', `true', `1'.

Valid false values are `n', `no', `f', `false', `0', .

Case doesn't matter.

=item `u' or `unsigned'

unsigned integer.

=item `i' or `integer'

integer

=item `f', `float', `n' or `number'

float number

=item `s', `string', `a' or `any'

anything is ok.

=back

=back

=item `required => [...]'

properties that have to be included in the configuration file. When
someone is missing, an exception is raised telling the user the
reason.

=back

Any option accepted by the Config::Find manpage can also be used in `new'
method.

=item $this->save(%%opts)

creates a new configuration file with the properties defined in the
object.

`%%opts' are passed to `Config::Find->find()' to determine the
configuration file name and location.

=item $this->fail($error)

method to be called from inside validation subs to report an error. It
appends the filename and the line number to the error and throws an
exception that if uncatched will show the user what went wrong.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
