%define module_name Config-Simple-Conf
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.007
Release: alt1
Summary: A fast and lightweight configuration file handler
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CF/CFABER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The idea behind Config::Simple::Conf came from various INI style parsers I've used in the past. In general these have worked well with the exception of lack of complex configuration handling.

Config::Simple for example fails to account for common cases which are extremely useful in any configuration file. These include useful handling of duplicate keys (currently Config::Simple blows them away without any notice), and second, internal macros.

In many of my usage cases I want something like your standard .INI file format, with the above mentioned exceptions.

_# Define a configuration section
_[core section]

_# Define an entry in core section
_path = /root/to/my/stuff

_# Define a new configuration file section
_[section name]

_# Define an entry list and use the value from another section to complete
_# the configuration
_path = [core section:path]/abc
_path = [core section:path]/xyz

Such a configuration would allow me to do two things, establish a core path argument, which is then used in other sections, and have a section with multiple duplicate entires as a list.

An example of the code here would look something like:

_#!/usr/bin/perl

_use strict;
_use Config::Simple::Conf;

_my $conf = Config::Simple::Conf->new('/path/to/my.conf');

_print "My root is: " . $conf->value('core section', 'path') . "\n";
_print "My section paths are:\n";

_for($conf->value('section name', 'path')){
__print "\t$_\n";
_}

With the resulting output looking something like:

_My root is: /root/to/my/stuff
_My section paths are:
__/root/to/my/stuff/abc
__/root/to/my/stuff/xyz

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CHANGELOG README example
%perl_vendor_privlib/C*

%changelog
