# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Tie/IxHash.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Config-Terse
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: delimited key and value:
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CA/CADE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Config::Terse parses configuration files with very compact syntax, which 
may seem rude or unfriendly. It provides sections with keyword/value pairs, 
sections inheritance and named groups of sections.

Each line in the config file contains whitespace-delimited key and value:

  key         value
  anotherkey  other value
  koe         ne se chete

Sections begin with equal sign on new line, followed by the section name:

  =newsection
  
  sectionkey1  value
  newkey       value

Sections may inherit other sections. Inherited sections are specified with 
plus sign and name after the section name:

  =newsection  +othersection1  +othersection2  ...

Sections may be grouped in groupss. Group names are specified with "at" sign (@)
followed by the group name, after the section name:

  =apple  @fruits
  
Inheritance and groups can be combined but order is important! All inherited
sections specified before group is taken from the main (root) sections.
Inherited sections after group name is taken from the same group (if such
exists. 

Sections can be added to multiple groups. They will be linked together and
changing one section key will be visible in the other groups.

Here is an example:

  =green
    color  green
    
  =tree  @fruits
    isatree  yes
    
  =apple +green  @fruits  +tree
    name  this is a green apple tree
    
The "apple" section will inherit "green" section, then will be put in the
"fruits" group and finally will inherit the "tree" section from "fruits".

All section and key names are converted to upper case by default.

The result perl hash structure for all the examples combined will be:

  $VAR1 = {
            'GREEN' => {
                         'COLOR' => 'green'
                       },
            'MAIN' => {
                        'ANOTHERKEY' => 'other value',
                        'KEY' => 'value',
                        'KOE' => 'ne se chete'
                      },
            'FRUITS' => {
                          'TREE' => {
                                      'ISATREE' => 'yes'
                                    },
                          'APPLE' => {
                                       'COLOR' => 'green',
                                       'NAME' => 'this is a green apple tree',
                                       'ISATREE' => 'yes'
                                     }
                        },
            'NEWSECTION' => {
                              'SECTIONKEY1' => 'value',
                              'NEWKEY' => 'value'
                            }
          };

Default section name is 'MAIN'. It is used for keys in files without any 
sections or for keys in the leading part of a file where no section has been 
defined yet. Default section name can be changed with 'MAIN' option and will 
be modified by the 'CASE' option. See 'OPTIONS' section below.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README README.md COPYING
%perl_vendor_privlib/C*

%changelog
