# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp/Clan.pm) perl(Clone/PP.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Validate/Domain.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Object/InsideOut.pm) perl(Params/Validate.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/Class.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_version 0.2.6
%define module_name Config-Validate
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.6
Release: alt1
Summary: Validate data structures generated from
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CM/CMO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is for validating configuration data that has been read in
already and is in a Perl data structure.  It does not handle reading
or parsing configuration files since there are a plethora of available
modules on CPAN to do that task.  Instead it concentrates on verifying
that the data read is correct, and providing defaults where
appropriate.  It also allows you to specify that a given configuration
key may be available under several aliases, and have those renamed to
the canonical name automatically.

The basic model used is that the caller provides a schema as a perl
data structure that describes the constraints to verify against.  The
caller can then use the `Config::Validate' object to validate any
number of data structures against the configured schema.  If the data
structure conforms to the schema given, then a new data structure will
be returned, otherwise an exception is thrown.

Probably the easiest way to explain the intent is that
`Config::Validate' is trying to be like `Params::Validate' for
configuration files and other data structures.

This module has the following features:

=over

=item 
* Data structure depth is only limited by stack depth

=item
* Can provide defaults for missing items at any level of the data structure.

=item * Can require that items exist, or items can be optional.

=item * Can validate items in the data structure against a number of built in data types, and users can easily add more data types.

=item * Configuration keys can be known by several names, and will be normalized to the canonical name in the data structure returned by the validation.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
