%define module_name Config-Wild
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/pushd.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Lingua/Boolean/Tiny.pm) perl(List/Util.pm) perl(Log/Any.pm) perl(Log/Any/Test.pm) perl(Path/Tiny.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/TempDir/Tiny.pm) perl(Try/Tiny.pm) perl(blib.pm) perl(custom/failures.pm) perl(failures.pm) perl(namespace/clean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.02
Release: alt1
Summary: parse an application configuration file with wildcard keywords
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DJ/DJERIUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a simple package to parse and present to an application
configuration information read from a configuration file.
Configuration information in the file has the form

  keyword = value

where *keyword* is a token which may contain Perl regular expressions
surrounded by curly brackets, i.e.

  foobar.{\d+}.name = goo

and *value* is the remainder of the line after any whitespace following
the `=' character is removed.

Keywords which contain regular expressions are termed *wildcard*
keywords; those without are called *absolute* keywords.  Wildcard
keywords serve as templates to allow grouping of keywords which have
the same value.  For instance, say you've got a set of keywords which
normally have the same value, but where on occaision you'd like to
override the default:

  p.{\d+}.foo = goo
  p.99.foo = flabber

*value* may reference environmental variables or other Config::Wild
variables via the following expressions:

=over 4

=item *

Environment variables may be accessed via `${var}':

  foo = ${HOME}/foo

If the variable doesn't exist, the expression is replaced with
an empty string.


=item *

Other Config::Wild variables may be accessed via `$(var)'.

  root = ${HOME}
  foo = $(root)/foo

If the variable doesn't exist, the expression is replaced with
an empty string.  Variable expansions can be nested, as in

  root = /root
  branch = $(root)/branch
  tree = $(branch)/tree

`tree' will evaluate to `/root/branch/tree'.

=item *

*Either* type of variable may be accessed via `$var'.
In this case, if *var* is not a Config::Wild variable, it is
assumed to be an environmental variable.
If the variable doesn't exist, the expression is left as is.

=back

Substitutions are made when the value method is called, not when
the values are first read in.

Lines which begin with the `#' character are ignored.  There is also a
set of directives which alter the where and how Config::Wild reads
configuration information.  Each directive begins with the `%%' character
and appears alone on a line in the config file:

=over 4

=item %%include file

Temporarily interrupt parsing of the current input file, and switch
the input stream to the specified *file*.

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/C*

%changelog
