%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Any/Template.pm) perl(Carp.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Slurp/WithinPolicy.pm) perl(Getopt/Std.pm) perl(Log/Trace.pm) perl(Storable.pm) perl(Test/Assertions.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.036
%define module_name Config-Wrest
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.036
Release: alt1
Summary: Read and write Configuration data With References, Environment variables, Sections, and Templating
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BB/BBC/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module allows you to read configuration data written in a human-readable and easily-editable text format
and access it as a perl data structure. It also allows you to write configuration data from perl back to this format.

The data format allows key/value pairs, comments, escaping of unprintable or problematic characters,
sensible whitespace handling, support for Unicode data,
nested sections, or blocks, of configuration data (analogous to hash- and array-references), and the optional
preprocessing of each line through a templating engine. If you choose to use a templating engine then, depending
on the engine you're using, you can interpolate other values into the data, interpolate environment variables,
and perform other logic or transformations. The data format also allows you to use directives to alter the behaviour
of the parser from inside the configuration file, to set variables, to include other files, and for other
actions.

Here's a brief example of some configuration data. Note the use of quotes, escape sequences, and nested blocks:

_Language =  perl
_<imageinfo>
__width = 100     # This is an end-of-line comment
__height  100
__alt_text " square red image, copyright %%A9 2001 "
__<Nestedblock>
___colour red
__</>
__[Suffixes]
___.jpg
___.jpeg
__[/]
_</imageinfo>
_@include path/to/file.cfg
_[Days]
__Sunday
__Can%%{2019}t
__'Full Moon'
__<weekend>
___length 48h
__</>
__# and so on... This is a full-line comment
_[/]

This parses to the perl data structure:

_{
__Language => 'perl',
__imageinfo => {
___width => '100',
___height => '100',
___alt_text => " square red image, copyright \xA9 2001 ",
___Nestedblock => {
____colour => 'red'
___},
___Suffixes => [
____'.jpg',
____'.jpeg'
___],
__},
__Days => [
___'Sunday',
___"Can\x{2019}t",_# note the Unicode character in this string
___'Full Moon',
___{
____'length' => '48h'
___}
__],
__# ...and of course, whatever data was read from the included file "path/to/file.cfg"
_}

Of course, your configuration data may not need to use any of those special features, and might simply be key/value pairs:

_Basedir   /usr/local/myprogram
_Debug     0
_Database  IFL1

This parses to the perl data structure:

_{
__Basedir => '/usr/local/myprogram',
__Debug => '0',
__Database => 'IFL1',
_}

These data structures can be serialized back to a textual form using this module.

For details of the data format see the DATA FORMAT entry elsewhere in this document and the DIRECTIVES entry elsewhere in this document. Also see the CONSTRUCTOR OPTIONS entry elsewhere in this document for options
which affect the parsing of the data. All file input and output goes through the File::Slurp::WithinPolicy manpage.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes COPYING
%perl_vendor_privlib/C*
%perl_vendor_privlib/D*

%changelog
