%define module_name Const-Exporter
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Const/Fast.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Hash/Objectify.pm) perl(List/Util.pm) perl(Module/Metadata.pm) perl(Package/Stash.pm) perl(Pod/Coverage/TrustPod.pm) perl(Ref/Util.pm) perl(Sub/Identify.pm) perl(Test/DistManifest.pm) perl(Test/EOL.pm) perl(Test/Fixme.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test2/V0.pm) perl(if.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.3.0
Release: alt1
Summary: Declare constants for export.
Group: Development/Perl
License: artistic_2
URL: http://rrwo.tumblr.com

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RR/RRWO/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to declare constants that can be exported to
other modules.

To declare constants, simply group then into export tags:

  package MyApp::Constants;

  use Const::Exporer

    tag_a => [
       'foo' => 1,
       'bar' => 2,
    ],

    tag_b => [
       'baz' => 3,
       'bar',
    ],

    default => [
       'foo',
    ];

Constants in the "default" tag are exported by default (that is, they are added
to the `@EXPORTS' array).

When a constant is already defined in a previous tag, then no value is
specified for it. (For example, "bar" in "tab_b" above.)  If you do
give a value, the Const::Exporter manpage will assume it's another symbol.

Your module can include multiple calls to `use Const::Exporter', so
that you can reference constants in other expressions, e.g.

  use Const::Exporter

    tag => [
        '$zero' => 0,
    ];

  use Const::Exporter

    tag => [
        '$one' => 1 + $zero,
    ];

or even something more complex:

  use Const::Exporter

     http_ports => [
        'HTTP'     => 80,
        'HTTP_ALT' => 8080,
        'HTTPS'    => 443,
     ];

  use Const::Exporter

     http_ports => [
        '@HTTP_PORTS' => [ HTTP, HTTP_ALT, HTTPS ],
     ];

Constants can include traditional the constant manpage symbols, as well as
scalars, arrays or hashes.

Constants can include values defined elsewhere in the code, e.g.

  our $foo;

  BEGIN {
     $foo = calculate_value_for_constant();
  }

  use Const::Exporer

    tag => [ '$foo' ];

Note that this will make the symbol read-only. You don't need to
explicitly declare it as such.

Enumerated constants are also supported:

  use Const::Exporer

    tag => [

      [qw/ foo bar baz /] => 1,

    ];

will define the symbols "foo" (1), "bar" (2) and "baz" (3).

You can also specify a list of numbers, if you want to skip values:

  use Const::Exporer

    tag => [

      [qw/ foo bar baz /] => [1, 4],

    ];

will define the symbols "foo" (1), "bar" (4) and "baz" (5).

You can even specify string values:

  use Const::Exporer

    tag => [

      [qw/ foo bar baz /] => [qw/ feh meh neh /],

    ];

however, this is equivalent to

  use Const::Exporer

    tag => [
      'foo' => 'feh',
      'bar' => 'meh',
      'baz' => 'neh',
    ];


%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE SECURITY.md
%perl_vendor_privlib/C*

%changelog
