%define module_name Constant-FromGlobal
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/OptList.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(constant.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: declare constant(s) with value from global or environment variable
Group: Development/Perl
License: perl
URL: https://github.com/neilb/Constant-FromGlobal

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NEILB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module lets you define constants that either take their values from
global variables, or from environment variables. The constants are
function-style constants, like those created using the the constant manpage pragma.

Here's a minimal example showing how to set a constant from a global
variable:

 our $DEBUG;
 BEGIN {
     $DEBUG = 1;
 }
 use Constant::FromGlobal qw/ DEBUG /;

You might wonder why you might want to do that?
A better example is where a module sets a constant from a global
variable in its package, but you can set that variable before
using the module.
First, here's the module:

 package Foobar;
 use Constant::FromGlobal LOGLEVEL => { default => 0 };

Then elsewhere you can write something like this:

 BEGIN {
   $Foobar::LOGLEVEL = 3;
 }
 use Foobar;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/C*

%changelog
