# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(CGI/Util.pm) perl(Devel/Size.pm) perl(Errno.pm) perl(FCGI.pm) perl(Fcntl.pm) perl(HTML/FromANSI.pm) perl(IO/Handle.pm) perl(LWP/MediaTypes.pm) perl(List/Util.pm) perl(Net/Telnet.pm) perl(PadWalker.pm) perl(Plack.pm) perl(Plack/App/File.pm) perl(Plack/Request.pm) perl(Term/VT102.pm) perl(Time/HiRes.pm) perl(URI/Escape.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Continuity
%define upstream_version 1.6

%global __provides_exclude perl\\(HTTP::Daemon.*\\)
# no requires from doc:
%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Mix callbacks into the Continuity request object
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Coro.pm)
BuildRequires: perl(Coro/Event.pm)
BuildRequires: perl(Event.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(HTTP/Daemon.pm)
BuildRequires: perl(HTTP/Status.pm)
BuildRequires: perl-devel

BuildArch: noarch
Obsoletes: perl-Continuity < 1.600.0-2
Source44: import.info

%description
Continuity is a library to simplify web applications. Each session is
written and runs as a persistent application, and is able to request
additional input at any time without exiting. This is significantly
different from the traditional CGI model of web applications in which a
program is restarted for each new request.

The program is passed a '$request' variable which holds the request
(including any form data) sent from the browser. In concept, this is a lot
like a '$cgi' object from CGI.pm with one very very significant difference.
At any point in the code you can call $request->next. Your program will
then suspend, waiting for the next request in the session. Since the
program doesn't actually halt, all state is preserved, including lexicals
-- getting input from the browser is then similar to doing '$line = <>' in
a command-line application.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make

%check
%make test

%install
%makeinstall_std

%files
%doc Changes META.yml  README eg
%{perl_vendor_privlib}/*


%changelog
