Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform optional tests
%bcond_without perl_Convert_Age_enables_optional_tests

Name:       perl-Convert-Age
Version:    0.04
Release:    alt2_32
Summary:    Perl module that converts integer seconds into a "compact" form and back
License:    GPL+ or Artistic
URL:        https://metacpan.org/release/Convert-Age
Source0:    https://cpan.metacpan.org/authors/id/C/CF/CFEDDE/Convert-Age-%{version}.tar.gz
BuildArch:  noarch
%if !%{with perl_Convert_Age_enables_optional_tests}
BuildRequires:  coreutils
%endif
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Exporter.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)
%if %{with perl_Convert_Age_enables_optional_tests}
# Optional tests:
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
%endif
Source44: import.info

%description
This is a rather simple Perl module for dealing with time intervals.
Convert 189988007 seconds to compact form 6y7d10h26m47s.
Convert compact 5h37m5s to seconds 20225.

%prep
%setup -q -n Convert-Age-%{version}
%if !%{with perl_Convert_Age_enables_optional_tests}
rm t/pod*.t
perl -i -ne 'print $_ unless m{^t/pod.*\.t}' MANIFEST
%endif

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
