# BEGIN SourceDeps(oneline):
BuildRequires: perl(Math/Int128.pm) perl(Module/Build.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Convert-Base85
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: Encoding to and decoding from Base 85 strings
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JG/JGAMBLE/%{module_name}-%{version}.tar.gz
BuildArch: noarch
ExcludeArch: %ix86 %arm

%description
This module implements a *Base85* conversion for encoding binary
data as text. This is done by interpreting each group of sixteen bytes
as a 128-bit integer, which is then converted to a twenty-digit base 85
representation using the alphanumeric characters 0-9, A-Z, and a-z, in
addition to the punctuation characters !, #, $, %%, &, (, ), *, +, -, ;, <, =, >,
?, @, ^, _, `, {, |, }, and ~, in that order.

This creates a string that is five fourths (1.25) larger than the original
data, making it more efficient than the MIME::Base64 manpage's 3-to-4 ratio (1.3333).

As noted above, the conversion makes use of 128-bit arithmatic, which most
computers can't handle natively, which is why the module the Math::Int128 manpage
needs to be installed as well.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/C*

%changelog
