%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 1.03
%define module_name Convert-Translit
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Perl module for string conversion among numerous character sets
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GE/GENJISCH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module converts strings among 8-bit character sets defined by IETF RFC 1345 (about 128 sets).  The RFC document is included so you can look up character set names and aliases; it's also read by the module when composing conversion maps.  Failing functions or objects return undef value.

Export_OK Functions:

=over 4

=item transliterate()

returns a string in $result_chset for an argument string in $orig_chset, transliterating by a map composed by new().

=item build_substitutes()

rebuilds the file "substitutes" containing character definitions and approximate substitutions used when a character in $orig_chset isn't defined in $result_chset.  For example, "Latin capital A" may be substituted for "Latin capital A with ogonek".  It takes a long time to rebuild this file, but you should never need to.  Its only source of information is file "rfc1345".

=back

Object methods:

=over 4

=item new()

creates a new object for converting from $orig_chset to $result_chset, these being names (or aliases) of 8-bit character sets defined in RFC 1345.  If only one argument, then $orig_chset is assumed "ascii".  If three arguments, the third is verbosity flag.  Verbose output lists approximate substitutions and other compromises.

=item transliterate()

is same as the function of that name.

=item build_substitutes()

is same as the function of that name.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README TODO
%perl_vendor_privlib/C*

%changelog
