%define module_name Crypt-EC_DSA
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/EllipticCurve/Prime.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.009
Release: alt1
Summary: Elliptic Curve Digital Signature Algorithm (ECDSA)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HASH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Elliptic Curve Digital Signature Algorithm (ECDSA)

    use Crypt::EC_DSA;

    my $ecdsa = new Crypt::EC_DSA;

    my ($pubkey, $seckey) = $ecdsa->keygen;

    my $msg = 'Hello, world!';

    my $signature = $ecdsa->sign( Message => $msg, Key => $seckey );

    print "Verified\n" if $ecdsa->verify( Message => $msg, Key => $pubkey,
                                          Signature => $signature );
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
