Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform optional tests
%bcond_without perl_Crypt_GCrypt_enables_optional_test

Name:           perl-Crypt-GCrypt
Version:        1.26
Release:        alt10_30
Summary:        Perl interface to libgcrypt library
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Crypt-GCrypt
Source0:        https://cpan.metacpan.org/authors/id/A/AA/AAR/Crypt-GCrypt-%{version}.tar.gz
# For libgcrypt >= 1.6, CPAN RT#97201
Patch0:         Crypt-GCrypt-1.26-libgcrypt_1_6_support.diff
# Correct some warnings, CPAN RT#107300
Patch1:         Crypt-GCrypt-1.26-Correct-some-warnings.patch
# Adjust tests to libgcrypt >= 1.7, bug #1399193, CPAN RT#112504
Patch2:         Crypt-GCrypt-1.26-Use-an-encryption-key-in-the-test-suite.patch
Patch3:         perl-Crypt-GCrypt-c99.patch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  libgcrypt-devel >= 1.3.0
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Devel/CheckLib.pm)
BuildRequires:  perl(ExtUtils/Liblist.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(XSLoader.pm)
# Tests:
BuildRequires:  perl(ExtUtils/testlib.pm)
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/More.pm)
%if %{with perl_Crypt_GCrypt_enables_optional_test}
# Optional tests:
BuildRequires:  perl(Devel/Size.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(threads.pm)
BuildRequires:  perl(Thread/Queue.pm)
%endif
Source44: import.info

%description
Crypt::GCrypt provides a Perl interface to the libgcrypt cryptographic
functions. It currently supports symmetric ciphers such as AES/Rijndael,
Twofish, Triple DES, Arcfour etc.

%prep
%setup -q -n Crypt-GCrypt-%{version}
%patch0 -p0
%patch1 -p1
%patch2 -p1
%patch3 -p1
# Remove bundled modules
rm -r inc
perl -i -ne 'print $_ unless m{^inc/}' MANIFEST
%if !%{with perl_Crypt_GCrypt_enables_optional_test}
rm t/03-pod.t t/04-podcoverage.t t/05-size.t t/07-thread.t
perl -i -ne 'print $_ unless m{t/(?:03-pod|04-podcoverage|05-size|07-thread)\.t}' MANIFEST
%endif

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1 OPTIMIZE="$RPM_OPT_FLAGS"
%{make_build}

%install
%{makeinstall_std}
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changelog README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/Crypt*

%changelog
