%define module_version 0.75
%define module_name Crypt-HCE_MD5
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.75
Release: alt1
Summary: Perl extension implementing one way hash chaining encryption using MD5
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EE/EESTABROO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module implements a chaining block cipher using a one way hash.  This method of encryption is the same that is used by radius (RFC2138) and is also described in Applied Cryptography.

Two interfaces are provided in the module.  The first is straight block encryption/decryption the second does base64 mime encoding/decoding of the encrypted/decrypted blocks.

The idea is the the two sides have a shared secret that supplies one of the keys and a randomly generated block of bytes provides the second key.  The random key is passed in cleartext between the two sides.

An example client and server are packaged as modules with this module.  They are used in the tests.  They can also be found in the examples directory.

The 'KEYBUG' flag is for decrypting data encrypted with an older version of Crypt::HCE_MD5.  There was a bug in the chaining portion that prevented the full 16 bytes of the previous block from being using in creating the chaining hash.  Decrypt your old data and re-encrypt it without the KEYBUG flag.

The release after this one will have the KEYBUG feature removed, but I'll leave this version on CPAN

Thanks to Jake Angerman for pointing out the weakness.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/C*
%perl_vendor_privlib/auto/*

%changelog
