%define module_name Crypt-OpenSSL-Hash2Curve
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel libssl-devel perl(Carp.pm) perl(Crypt/OpenSSL/Base/Func.pm) perl(Crypt/OpenSSL/Bignum.pm) perl(Crypt/OpenSSL/EC.pm) perl(Crypt/OpenSSL/Guess.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/BigInt.pm) perl(Test.pm) perl(Test/More.pm) perl(bignum.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.033
Release: alt2
Summary: hash to curve
Group: Development/Perl
License: see LICENSE
URL: http://github.com/abbypan/Crypt-OpenSSL-Hash2Curve

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AB/ABBYPAN/%{module_name}-%{version}.tar.gz

%description
https://datatracker.ietf.org/doc/draft-irtf-cfrg-hash-to-curve/

=over

=item encode_to_curve

  my $P = encode_to_curve( $msg, $DST, $group_name, $type, $hash_name, $expand_message_func, $clear_cofactor_flag );

  my ($P, $group_params_ref) = encode_to_curve( $msg, $DST, $group_name, $type, $hash_name, $expand_message_func, $clear_cofactor_flag );

=item hash_to_curve

  my $P = hash_to_curve( $msg, $DST, $group_name, $type, $hash_name, $expand_message_func, $clear_cofactor_flag );

  my ($P, $group_params_ref)  = hash_to_curve( $msg, $DST, $group_name, $type, $hash_name, $expand_message_func, $clear_cofactor_flag );

=item get_hash2curve_params

    my $group_params_ref = get_hash2curve_params($group_name, $type);
    # $group_params_ref = [ $group, $c1, $c2, $p, $a, $b, $z, $ctx ];

=item map_to_curve

  my $P = map_to_curve( $params_ref, $group_name, $type, $u, $clear_cofactor_flag );

=item hash_to_field

  my $res_arr_ref =  hash_to_field( $msg, $count, $DST, $p, $m, $k, $hash_name, $expand_message_func );

=item expand_message_xmd

  my $s = expand_message_xmd( $msg, $DST, $len_in_bytes, $hash_name );

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod Changes LICENSE
%perl_vendor_archlib/C*
%perl_vendor_autolib/*

%changelog
