%define module_version 1.0.4
%define module_name Crypt-SEAL2
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XSLoader.pm) perl(diagnostics.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.4
Release: alt8
Summary: The SEAL stream cipher, version 2.0
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JC/JCDUQUE/%{module_name}-%{module_version}.tar.gz
# TODO: fix compilation on other arches
ExclusiveArch: %{ix86}

%description
SEAL2 is the second version of the stream cipher, SEAL, designed by Don
Coppersmith and Phillip Rogaway.

This module supports the following functions:

=over

=item new()

Creates a pseudorandom string (PRS), using a user-supplied key as a
seed to the pseudorandom generator of SEAL2. A PRS pointer
initially points at the beginning of the PRS.

=item encrypt($data)

Encrypts the data stream $data by XOR-ing it with the PRS,
starting at the position being pointed to by the PRS pointer, and
returns the resulting ciphertext. The PRS pointer is advanced 1 byte
position for every byte of $data that is encrypted.

=item decrypt($data)

Decrypts the data stream $data by XOR-ing it with the PRS,
starting at the position being pointed to by the PRS pointer, and
returns the resulting plaintext. The PRS pointer is advanced 1 byte
position for every byte of $data that is decrypted.

decrypt($data) is exactly the same as encrypt($data).


=item reset()

Every time a call to either encrypt() or decrypt() is performed,
the PRS pointer is advanced. Therefore, it is necessary to reset()
the pointer in order to encrypt/decrypt the data stream correctly.
Alternatively, you may use repos() to manually re-position the
PRS pointer to where the encryption/decryption will start (see next
function).

=item repos($position)

Re-positions the PRS pointer at byte position $position

=item keysize()

Returns the size (in bytes) of the key used (20, in this case)

=back


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README example
%perl_vendor_archlib/C*
%perl_vendor_autolib/*

%changelog
