%define module_name Crypt-Spritz
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Canary/Stability.pm) perl(ExtUtils/MakeMaker.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt6
Summary: Spritz stream cipher/hash/MAC/AEAD/CSPRNG family
Group: Development/Perl
License: see COPYING
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ML/MLEHMANN/%{module_name}-%{version}.tar.gz

%description
This module implements the Spritz spongelike function (with N=256), the
spiritual successor of RC4 developed by Ron Rivest and Jacob Schuldt.

Its strength is extreme versatility (you get a stream cipher, a hash, a
MAC, a DRBG/CSPRNG, an authenticated encryption block/stream cipher and
more) and extremely simple and small code (encryption and authentication
can be had in 1KB of compiled code on amd64, which isn't an issue for most
uses in Perl, but is useful in embedded situations, or e.g. when doing
crypto using javascript in a browser and communicating with Perl).

Its weakness is its relatively slow speed (encryption is a few times
slower than RC4 or AES, hashing many times slower than SHA-3, although
this might be reversed on an 8-bit-cpu) and the fact that it is totally
unproven in the field (as of this writing, the cipher was just a few
months old), so it can't be called production-ready.

All the usual caveats regarding stream ciphers apply - never repeat your
key, never repeat your nonce and so on - you should have some basic
understanding of cryptography before using this cipher in your own
designs.

The Spritz base class is not meant for end users. To make usage simpler
and safer, a number of convenience classes are provided for typical
end-user tasks:

   random number generation - Crypt::Spritz::PRNG
   hashing                  - Crypt::Spritz::Hash
   message authentication   - Crypt::Spritz::MAC
   encryption               - Crypt::Spritz::Cipher::XOR
   encryption               - Crypt::Spritz::Cipher
   authenticated encryption - Crypt::Spritz::AEAD::XOR
   authenticated encryption - Crypt::Spritz::AEAD

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYING Changes
%perl_vendor_archlib/C*
%perl_vendor_autolib/*

%changelog
