%define module_name CtrlO-Crypt-XkcdPassword
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor/Fast.pm) perl(Crypt/Rijndael.pm) perl(Crypt/URandom.pm) perl(Data/Entropy.pm) perl(Data/Entropy/Algorithms.pm) perl(Data/Entropy/RawSource/CryptCounter.pm) perl(Data/Entropy/Source.pm) perl(Data/Handle.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Build.pm) perl(Module/Runtime.pm) perl(Pod/Usage.pm) perl(Test/Exception.pm) perl(Test/SharedFork.pm) perl(WordList.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.011
Release: alt1
Summary: Yet another xkcd style password generator
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DO/DOMM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`CtrlO::Crypt::XkcdPassword' generates a random password using the
algorithm suggested in https://xkcd.com/936/: It selects 4 words
from a curated list of words and combines them into a hopefully easy
to remember password (actually a passphrase, but we're all trying to
getting things done, so who cares..).

See this explaination
for detailed information on the security of passwords generated from a
known word list.

But https://xkcd.com/927/ also applies to this module, as there are
already a lot of modules on CPAN implementing
https://xkcd.com/936/. We still wrote a new one, mainly because we
wanted to use a strong source of entropy and a fine-tuned word list.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/C*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
