%define module_name DB-SimpleKV
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.18
Release: alt1
Summary: Simple k/v interface to text configuration file
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Y/YH/YHPENG/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
This module is mainly used to manipulate a configuration file like Postfix's main.cf.

It creates the default db file "/tmp/simplekv.db" if you don't specify the file path.

    use DB::SimpleKV;

    my $db = DB::SimpleKV->new;
    $db->set("hostname","h99.foo.com");
    $db->set("provider","rackspace cloud");
    $db->set("ip_addr","192.168.2.10");
    $db->set("netmask","255.255.255.0");

    print $db->get("provider"),"\n";
    $db->delete("netmask");
    print  "netmask exists? ", $db->exists("netmask") ? "yes" : "no", "\n";

    $db->save;

Or you can specify the existing file for manipulation, one configuration per line, with '=' as delimiter.

    use DB::SimpleKV;

    my $db = DB::SimpleKV->new("/etc/postfix/main.cf");
    print $db->get("relayhost"),"\n";
    print  "relay exists? ", $db->exists("relayhost") ? "yes" : "no", "\n";

%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README ignore.txt
%perl_vendor_privlib/D*

%changelog
