%define module_name DBD-XMLSimple
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DBI.pm) perl(DBI/DBD/SqlEngine.pm) perl(ExtUtils/MakeMaker.pm) perl(IPC/System/Simple.pm) perl(SQL/Statement.pm) perl(Test/CleanNamespaces.pm) perl(Test/DatabaseRow.pm) perl(Test/Differences.pm) perl(Test/Distribution.pm) perl(Test/Kwalitee.pm) perl(Test/Most.pm) perl(Test/NoWarnings.pm) perl(Test/Perl/Metrics/Simple.pm) perl(Test/Script.pm) perl(XML/Twig.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Access XML data via the DBI interface
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Reads XML and makes it available via DBI.

    use FindBin qw($Bin);
    use DBI;

    my $dbh = DBI->connect('dbi:XMLSimple(RaiseError => 1):');

    # To be replaced with xmls_import once the driver has been registered
    $dbh->func('person', 'XML', "$Bin/../data/person.xml", 'x_import');

    my $sth = $dbh->prepare("SELECT * FROM person");

Input data will be something like this:

    <?xml version="1.0" encoding="US-ASCII"?>
    <table>
_<row id="1">
_    <name>Nigel Horne</name>
_    <email>njh@bandsman.co.uk</email>
_</row>
_<row id="2">
_    <name>A N Other</name>
_    <email>nobody@example.com</email>
_</row>
    </table>

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes README ignore.txt
%perl_vendor_privlib/D*

%changelog
