# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DBICx/TestDatabase.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Schema.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name DBICx-MaterializedPath
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: the DBIx::Class manpage plugin for automatically tracking lineage paths in simple data trees.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AS/ASHLEY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Note, this is an experimental package and not sanctioned by the DBIC core devs.

Uses a column of a table with a tree structure to keep track of lineage. An example lineage showing primary key idsE<ndash>

 #  1 -> 2 -> 3 -> 10 -> 999 -> 8 -> 42

 my $rec = $result_source->find(999);
 say $rec->parent->id; # prints "10"

It's trivial to find the parent and easy to recurse on the parent to find all ancestors. With a deep tree it becomes somewhat expensive. Take the example above, for example. If you want to get the entire lineage for the record with id "42" you have to do six queries against the database. If you maintain a materialized path you only have to do one.

Consider our record "42" again. With its path 1/2/3/10/999/8/42 we can easily find all its parentsE<ndash>

 my $path = "1/2/3/10/999/8/42";
 my @ancestor_ids = split '/', $path;
 pop @ancestor_ids; # Remove the self id.
 my @ancestors = $result_source
                      ->search({ parent => { -in => \@ancestor_ids },
                               { order_by => \"LENGTH(path)" });

We can thank the great and powerful Ovid's co-worker Mark MorganE<mdash>http://use.perl.org/~Ovid/journal/39460E<mdash>for the sorting solution for ensuring the proper order of ancestors is returned.

See also *Trees in SQL: Nested Sets and Materialized Path*, Vadim Tropashko, http://www.dbazine.com/oracle/or-articles/tropashko4.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
