%define module_name DBIx-Array
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(DBD/CSV.pm) perl(DBD/SQLite.pm) perl(DBD/XBase.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(Test/Simple.pm) perl(Tie/Cache.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.65
Release: alt1
Summary: This module is a wrapper around DBI with array interfaces
Group: Development/Perl
License: mit
URL: https://github.com/mrdvt92/perl-DBIx-Array

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MR/MRDVT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is for people who truly understand SQL and who understand Perl data structures.  If you understand how to modify your SQL to meet your data requirements then this module is for you.  In the example below, only one line of code is needed to generate an entire HTML table.

  print &tablename($dba->sqlarrayarrayname(&sql, 15)), "\n";

  sub tablename {
    use CGI; my $html=CGI->new(""); #you would pass this reference
    return $html->table($html->Tr([map {$html->td($_)} @_]));
  }
   
  sub sql { #Oracle SQL
    return q{SELECT LEVEL AS "Number",
                    TRIM(TO_CHAR(LEVEL, 'rn')) as "Roman Numeral"
               FROM DUAL CONNECT BY LEVEL <= ? ORDER BY LEVEL};
  }

This module is used to connect to both Oracle 10g and 11g using the DBD::Oracle manpage on both Linux and Win32, MySQL 4 and 5 using the DBD::mysql manpage on Linux, and Microsoft SQL Server using the DBD::Sybase manpage on Linux and using the DBD::ODBC manpage on Win32 systems in a 24x7 production environment.  The tests are written against the DBD::CSV manpage and the DBD::XBase manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README.md Changes CONTRIBUTING.md LICENSE
%perl_vendor_privlib/D*

%changelog
