%define module_name DBIx-AutoUpgrade-NativeStrings
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/Locale.pm) perl(Encode/TW.pm) perl(Getopt/Long.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(utf8.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: automatically upgrade Perl native strings to utf8 before sending them to the database
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAMI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module intercepts calls to the DBI manpage methods for automatically converting Perl native strings
to utf8 strings before they go to the DBD driver.

There are two situations where it is useful :

=over

=item 1.

Some DBD drivers *do not comply* with this DBI specification :

=over

*Perl supports two kinds of strings: Unicode (utf8 internally) and
non-Unicode (defaults to iso-8859-1 if forced to assume an
encoding). Drivers should accept both kinds of strings and, if
required, convert them to the character set of the database being
used. Similarly, when fetching from the database character data that
isn't iso-8859-1 the driver should convert it into utf8.*

=back

For example with the DBD::Oracle manpage v1.83 and with a client charset set to `AL32UTF8',
native string with characters in the range 128 .. 255 are not converted to utf8 strings;
therefore characters in that range become Unicode code points in block
C1 control codes,
without any graphical display, which is not their intended meaning.

=item 2.

Drivers that *do attempt to comply* with the DBI specification, like for
example the DBD::SQLite manpage or the DBD::Pg manpage, perform an automatic upgrade of
native strings ... assuming that the native character set is
iso-8859-1 (Latin-1). However some platforms have different native
character sets; in particular, the default "codepage" on Windows
machines is Windows-1252, where
code points in the range 128-159 are mapped to various graphical
characters.  So if your native strings assume Windows-1252 encoding,
such characters will not be stored correctly within the database
server.

=back

With the present module, clients explicitly specify at initialization time
what is the native encoding.  From that, the module automatically
converts native strings to their proper Unicode counterpart before
sending them to the database.

Of course this only makes sense when the connection to the database
is in Unicode mode. Each DBD driver has its own specific way of
setting the character set used for the...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/D*

%changelog
