%define module_name DBIx-BatchChunker
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CLDR/Number.pm) perl(Class/Load.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Connector.pm) perl(DBIx/Connector/Retry.pm) perl(Env.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/Util.pm) perl(Math/BigFloat.pm) perl(Math/BigInt.pm) perl(Moo.pm) perl(MooX/StrictConstructor.pm) perl(POSIX.pm) perl(Path/Class.pm) perl(Path/Class/File.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Term/ProgressBar.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/Bundle/More.pm) perl(Test2/Tools/Compare.pm) perl(Test2/Tools/Exception.pm) perl(Test2/Tools/Explain.pm) perl(Time/HiRes.pm) perl(Type/Utils.pm) perl(Types/Numbers.pm) perl(Types/Standard.pm) perl(base.pm) perl(lib.pm) perl(namespace/clean.pm) perl(strict.pm)
BuildRequires: perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.2
Release: alt1
Summary: Run large database changes safely
Group: Development/Perl
License: artistic_2
URL: https://github.com/GrantStreetGroup/DBIx-BatchChunker

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GS/GSG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This utility class is for running a large batch of DB changes in a manner that doesn't
cause huge locks, outages, and missed transactions.  It's highly flexible to allow for
many different kinds of change operations, and dynamically adjusts chunks to its
workload.

It works by splitting up DB operations into smaller chunks within a loop.  These chunks
are transactionalized, either naturally as single-operation bulk work or by the loop
itself.  The full range is calculated beforehand to get the right start/end points.
A progress bar will be created to let the deployer know the
processing status.

There are two ways to use this class: call the automatic constructor and executor
(the construct_and_execute entry elsewhere in this document) or manually construct the object and call its methods. See
the SYNOPSIS entry elsewhere in this document for examples of both.

DISCLAIMER: You should not rely on this class to magically fix any and all locking
problems the DB might experience just because it's being used.  Thorough testing and
best practices are still required.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md CHANGES LICENSE README examples
%perl_vendor_privlib/D*

%changelog
