# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DBIx/Class.pm) perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Storable.pm) perl(Test/Differences.pm) perl(Test/Exception.pm) perl(Test/MockObject.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(autobox/Core.pm) perl(base.pm) perl(strict.pm) perl(true.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 1.004
%define module_name DBIx-Class-BatchUpdate
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.004
Release: alt1
Summary: Update batches of DBIC rows with as few queries as possible
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JO/JOHANL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is for when you have loads of DBIC rows to update as part
of some large scale processing, and you want to avoid making
individual calls to $row->update for each of them. If the number of
dirty rows is large, the many round-trips to the database will be
quite time consuming.

So instead of calling $row->update you collect all the dirty row
objects (of the same Result class) for later and then let
DBIx::Class::BatchUpdate update the database with as few queries as
possible.

This means that if the same columns have been set to the same value in
all the rows, this will be done in a single query. The more different
combinations of columns and values there are in rows, the more queries
are required.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/D*

%changelog
