%define module_name DBIx-Class-DeploymentHandler-CLI
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/Any.pm) perl(DBIx/Class/DeploymentHandler.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(Path/Tiny.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(Type/Tiny.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3.0
Release: alt1
Summary: Command line interface for deployment handler
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HO/HORNBURG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides an command line interface for
the DBIx::Class::DeploymentHandler manpage.

A sample script using this module looks like:

    #! /usr/bin/env perl

    use strict;
    use warnings;

    use PerlDance::Schema;
    use DBIx::Class::DeploymentHandler::CLI;

    my $schema = PerlDance::Schema->connect('perldance');

    my $dh_cli = DBIx::Class::DeploymentHandler::CLI->new(
        schema => $schema,
        databases => 'MySQL',
        args => \@ARGV,
    );

    if (my $ret = $dh_cli->run) {
       print $ret, "\n";
    }

Let's assume that you name the script `dh-cli'.

Now you can call the module's methods through commandline
parameters:

    ./dh-cli prepare-version-storage
    ./dh-cli install-version-storage

It doesn't matter whether you use dashes (` - ') or
underscores (` _ ') in the function name.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%files scripts
%_bindir/*

%changelog
