# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Indexed.pm) perl(DBIx/Class/Schema.pm) perl(DBIx/Class/TimeStamp.pm) perl(Dezi/Client.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(MIME/Base64.pm) perl(Media/Type/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/MockModule.pm) perl(Test/More.pm) perl(XML/Simple.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(DateTime/Format/SQLite.pm)
# END SourceDeps(oneline)
%define module_version 0.08
%define module_name DBIx-Class-Indexer-WebService-Dezi
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: An indexer for Dezi/Lucy.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/L/LO/LOGIE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module was inspired (and borrowed some) by DBIx::Class::Indexer::WebService::Solr.
In fact it uses DBIx::Class::Indexer as its abstract class.  This indexer allows one to 
use a Dezi::Client to update the index on "insert", "update", or "delete".

    package MyApp::Schema::Foo; 
    use base 'DBIx::Class';

    __PACKAGE__->load_components( qw[ Indexed ] );
    __PACKAGE__->set_indexer( 'WebService::Dezi', { server => 'http://localhost:5000', content_type => 'application/json' } );
    
    __PACKAGE__->table('person');
    
    __PACKAGE__->add_columns(
        person_id => {
            data_type       => 'varchar',
            size            => '36',
            is_nullable     => 0,
        },
        name => {
            data_type       => 'varchar',
            is_nullable     => 0,
            indexed         => 1 
        },
        age => {
            data_type       => 'integer',
            is_nullable     => 0,
        },
        image_path => {
            data_type       => 'varchar',
            size            => '128',
            indexed         => { is_binary => 1, base64_encode => 1 },
        },
        email => {
            data_type       => 'varchar',
            size            => '128',
        },
        created => {
            data_type       => 'timestamp',
            set_on_create   => 1,
            is_nullable     => 0,
        },
    );


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
