# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBIx/Class.pm) perl(Markup/Unified.pm) perl(Test/More.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.021
%define module_name DBIx-Class-InflateColumn-Markup-Unified
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.021
Release: alt1
Summary: Automatically formats a text column
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/ID/IDOPEREL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Load this component and declare that text columns use a markup language.
You can either "hard code" the markup language into the column, or grab it
from another column in the row (must be 'markup_lang' right now). This is
useful if each row might use a different markup langauge. Supported languages
are Textile, Markdown and BBCode.

    package Posts;
    __PACKAGE__->load_components(qw/InflateColumn::Markup Core/);
    __PACKAGE__->add_columns(
        text => {
            data_type => 'TEXT',
            is_nullable => 0,
            is_markup => 1,
            markup_lang => 'textile',
        }
    );

    # or, alternatively
    __PACKAGE__->add_columns(
        text => {
            data_type => 'TEXT',
            is_nullable => 0,
            is_markup => 1,
        },
        markup_lang => {
            data_type => 'VARCHAR',
            is_nullable => 0,
            size => 60,
        },
    );

Then, printing the column will automatically use the markup language:

    print $row->text; # automatically formats according to the markup language

    # you can also use
    print $row->text->formatted; # again, automatically formats
    print $row->text->unformatted; # prints the text as-is, unformatted


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
