# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/C3/Componentised.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Helpers.pm) perl(DBIx/Introspector.pm) perl(Devel/Dwarn.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Runtime.pm) perl(SQL/Translator.pm) perl(Sub/Current.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_name DBIx-Class-MaterializedPath
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002001
Release: alt1
Summary: efficiently retrieve and search trees with DBIx::Class
Group: Development/Perl
License: perl
URL: https://github.com/frioux/DBIx-Class-MaterializedPath

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FR/FREW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Materialized path is a
way to store trees in relational databases that results in very efficient
retrieval, at the expense of space and more write-time queries.

This module makes using matpaths easy.  The interface is somewhat unusual, but
the benefit is that it creates actual relationships for the both directions of
the tree, allowing you to use the powerful querying the DBIx::Class manpage already gives
you.

The first strange part of the interface is that the call to `load_components'
must come after the call to `table'.  The next strange bit is that the way
you define all of the metadata about your matpath is by defining a subroutine
called `materialized_path_columns'.  The subroutine must return a hashref
where the key is name of your path (currently unused) and the value is the
metadata for the path.  Here are the parts that need to be defined in the
metadata:

=over 2

=item * `parent_column' - the column that points directly to the parent row,
for example `parent_id'.

=item * `parent_fk_column' - the column that `parent_column' points to, for
example `id'.

=item * `materialized_path_column' - the column that contains the materialized
path.  One thing to note here is that the width of the column defines how
deep your tree can be.  For example if the number of digits for most of your
`id''s is three, and your materialized path column is 255 characters wide, you
can support a depth of something like 63 levels, because each level in the tree
is `q(/) . "$id"', so `255/4 ~~ 63'.  An example for this might be
`parent_materialized_path'.

=item * `parent_relationship' - the direct relationship to your parent row

=item * `children_relationship' - the direct relationship to your child rows

=item * `full_path' - the name of the relationship that this materialized path
will define for all parents.  For example, `ancestry'.

=item * `reverse_full_path' - the name of the relationship that this
materialized path will define for all children.  For example, `descendants'.

=item * `include_self_in_path' - (o...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/D*

%changelog
