# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Accessor/Grouped.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Result/ColumnData.pm) perl(DBIx/Class/Schema.pm) perl(Exporter.pm) perl(Module/Build.pm) perl(SQL/Translator.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name DBIx-Class-Result-ExternalAttribute
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: DBIx Class Result ExternalAttribute
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NO/NOUDARD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use attached model to store attribute.

for example artist result:

    package t::app::Main::Result::Artist;
    use base qw/DBIx::Class::Core/;
    __PACKAGE__->table('artist');
    __PACKAGE__->add_columns(
        "id",
        { data_type => "integer", is_auto_increment => 1, is_nullable => 0 },
        "name",
        {   data_type     => "varchar",
            default_value => "",
            is_nullable   => 0,
            size          => 255
        });
    __PACKAGE__->set_primary_key('id');

    __PACKAGE__->load_components(qw/ Result::ExternalAttribute Result::ColumnData /);
    __PACKAGE__->init_external_attribute(
        artist_attribute =>
          't::app::Main::Result::ArtistAttribute',
        'artist_id'
    );
    __PACKAGE__->register_relationships_column_data();

use a artist attribute result:

    package t::app::Main::Result::ArtistAttribute;
    use base qw/DBIx::Class::Core/;
    __PACKAGE__->table('artist_attribute');
    __PACKAGE__->add_columns(
        "artist_id",
        { data_type => "integer", is_nullable => 0 },
        "year_old",
        { data_type     => "integer", is_nullable   => 1});
    __PACKAGE__->set_primary_key('artist_id');
    __PACKAGE__->load_components(qw/ Result::ColumnData /);
    __PACKAGE__->belongs_to( artist => "t::app::Main::Result::Artist", 'artist_id');

    1;

with this configuration, you can call methods:

    $artist->get_column_data => get only columns of artist result

    $artist->get_column_data_with_attribute => get columns of Artist and ArtistAttribute result except artist_id

    #update with artist attributes
    $artist->update({name => "Me", year_old => 15});

    #create with artist attributes
    my $rh = t::app::Main::Result::Artist->prepare_params_with_attribute({name => "Me", year_old => 15});
    $schema->resultset('Artist')->create($rh);


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
