# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(Module/Build/Tiny.pm) perl(SQL/Translator.pm) perl(Try/Tiny.pm) perl(autovivification.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.10
%define module_name DBIx-Class-ResultSet-AccessorsEverywhere
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Component for DBIx::Class that allows the use of accessor names in search/create/etc
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGRIMES/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
package Schema::ResultSet::User;
    use parent 'DBIx::Class::ResultSet';
    __PACKAGE__->load_components('AccessorsEverywhere');
    1;

    package Schema::Result::User;
    use parent qw/DBIx::Class::Core/;
    __PACKAGE__->table("users");
    __PACKAGE__->add_columns(
        id => {
            data_type         => "integer",
            is_auto_increment => 1,
            is_nullable       => 0,
        },
        'the_firstNameX' => {   # a really poorly named column in the db
            accessor    => 'first_name',     # a "perlish" accessor
            data_type   => "varchar",
            is_nullable => 1,
            size        => 255
        },
    );
    __PACKAGE__->set_primary_key("id");
    1;

    ## Your app:
    $schema->resultset('User')->create({ first_name => 'Bill' });
    $schema->resultset('User')->search({ first_name => 'Bill' });

By specifying the `accessor' attribute when defining a table schema,
the DBIx::Class manpage can change the name of accessors it creates for those columns.
This can be extremely helpful when the database fields are poorly named and
not under your control. Unfortunately, DBIx::Class expects the table column
names when creating new entries, searching, etc.

`DBIx::Class::AccessorsEverywhere' is component that can be loaded into your
ResultSet classes that allows the use of the accessor names instead in
create, search, etc. operations.

This is an early release. Don't expect this to work everywhere. The following
DBIx::Class methods have been tested, others might work, but need to be tested.

    $rs->create({ accessor_name => 'value' });
    $rs->search({ accessor_name => 'value' });


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE
%perl_vendor_privlib/D*

%changelog
