%define module_name DBIx-Class-ResultSet-SetControl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Test/DBIx/Class.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Easier Looping over resultsets
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/DBIx-Class-ResultSet-SetControl

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
There are times where Perl's procedural syntax for control flow and looping
leads to excessively verbose code.  For those times we present this helper
which is designed to encapsulate some very common control flow and loop patterns
for the DBIx::Class manpage users.

The methods are OO in nature and designed to be compact and concise.

Additionally, we have tried to write these methods to allow for a 'chaining'
approach that you can't replicate with traditional Perl control and looping
structures.  Each control flow method returns the original resultset so you
can proceed as though it is unaltered (unless of course you alter it somehow
like with an insert or update).

The goal it to help avoid excessive conditional logic and to allow one to write
more compact and neat code.  For example, you could replace:

    my $has_rows;
    while(my $row = $rs->next) {
      $has_rows = 1;
      ## Do something
    }
    unless($has_rows) {
      warn 'no rows!';
    }

With something like

    $rs->each(sub {
      my ($each, $row) = @_;
      ## Do Something
    }, sub {
      warn 'no rows!';
    });

The second version has less overall lines and characters, and it also carefully
encapsulates a very common pattern, which is to loop over all the rows in a
resultset and do something should no rows exist.  Also, the the each entry elsewhere in this document method
returns the original `$rs' so you could chain commands:

    $rs->each(sub {
      my ($each, $row) = @_;
      ## Do Something
    }, sub {
      warn 'no rows!';
    })->tap(sub {
      my $rs = shift;
      ## Do something else
    });

There may be cases in your logical flow where this type of programming is more
clear and simple; in other cases traditional Perl control and looping might be
better.  These methods give you an option.  On the other hand you might think
this is all pointless line noise.  As you wish :)
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.mkdn LICENSE
%perl_vendor_privlib/D*

%changelog
