# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Carp/Clan.pm) perl(Class/Accessor/Grouped.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DBIx/Class/Schema/Loader.pm) perl(DBIx/Class/Schema/Loader/DBI.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(MRO/Compat.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(mro.pm) perl(namespace/clean.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.01043
%define module_name DBIx-Class-Schema-Loader-DBI-RelPatterns
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01043
Release: alt1
Summary: Relationship patterns for DBIx::Class::Schema::Loader
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/L/LE/LEWA/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
DBIx::Class::Schema::Loader::DBI::RelPatterns is a pseudo loader class that provides the means to set up the table relationships when DBIx::Class::Schema::Loader fails to for any reason. It is designed for use with storage engines that do not support foreign keys, such as MySQL's MyISAM; but should work with pretty much any DBI driver that:

=over

=item *

properly supports `statistics_info' method (DBD::mysql does starting from version 4.029; DBD::SQLite - from 1.40)

=item *

and, more important, is explicitly supported by DBIx::Class::Schema::Loader DBI implementation.

=back

Unlike conventional loader classes, DBIx::Class::Schema::Loader::DBI::RelPatterns allows DBIx::Class::Schema::Loader::DBI to load a driver-specific class, then extends it and wraps some of its methods (hence the word "pseudo"), adding to the mix the relationship patterns, user-definable via the rel_constraint entry elsewhere in this document and the rel_exclude entry elsewhere in this document options (which are added to the base options of DBIx::Class::Schema::Loader). If the rel_constraint entry elsewhere in this document option is not specified, DBIx::Class::Schema::Loader::DBI::RelPatterns becomes a no-op, passing through to the driver-specific class. Otherwise it helps to set up the relationships whenever corresponding columns in the referencing key and the referenced key meet all of the following conditions:

=over

=item *

they match any of the `rel_constraint' patterns;

=item *

they match none of the `rel_exclude' patterns;

=item *

they have exactly the same or similar data types.

=back

In general, the columns also have to be indexed. However, `rel_constraint' patterns allow one to explicitly specify that being indexed is not mandatory. This seems like a bad idea, but you may want to (or even have to) do this if the DBI driver in use does not support `statistics_info' method, which is required to obtain the non-unique index information (which is useless to DBIx::Class but can help to avoid the false-positive `rel_constraint' pattern matches when patterns are not specific enough). Although in such a case the composite-key relationships may be left out, thus limiting the resulting DBIx::Class schema to simple-key relationships.

When multiple columns in the referenced table meet the conditions, preference is given - in order of priority - to column that is listed in:

=over

=item *

primary key;

=item *

unique key;

=item *

single-column index;

=item *

composite index as the first column or closer to the first column;

=item *

largest composite index.

=back

If a relationship pattern is way too vague, you may be warned that multiple columns or even tables meet the conditions for some foreign key and have equal priority. To avoid such warnings, either come up with a more specific relationship pattern or exclude the unwanted columns or tables via the rel_exclude entry elsewhere in this document option.

By design, all determined relationships are considered to be *simple-key* relationships. However, when multiple relationships between two tables are identified, and columns of these relationships are listed in the corresponding composite indexes as the first columns (i.e., they form the leftmost prefixes), then a *composite-key* relationship is set up instead of multiple *simple-key* ones.

Note that `rel_constraint' and `rel_exclude' patterns do not affect the relationships that DBIx::Class::Schema::Loader is able to identify unaided. That is, DBIx::Class::Schema::Loader::DBI::RelPatterns helps to add missing relationships but not alter or remove the ones already identified.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes README.mkdn
%perl_vendor_privlib/D*

%changelog
