%define module_version 0.19
%define module_name DBIx-Class-Schema-PopulateMore
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/ResultSet.pm) perl(DBIx/Class/Schema.pm) perl(DateTime/Format/SQLite.pm) perl(DateTimeX/Easy.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Module/Manifest/Skip.pm) perl(Module/Pluggable.pm) perl(Module/Pluggable/Object.pm) perl(Moo.pm) perl(MooX/HandlesVia.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Path/Class.pm) perl(Pod/Simple.pm) perl(Pod/Simple/Methody.pm) perl(SQL/Translator.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Data/Perl/Role/Collection/Hash.pm)
BuildRequires: perl(Test/More.pm) perl(Type/Library.pm) perl(Type/Tiny.pm) perl(Types/Standard.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(namespace/clean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.19
Release: alt1
Summary: An enhanced populate method
Group: Development/Perl
License: perl
URL: http://search.cpan.org/dist/DBIx-Class-Schema-PopulateMore/

Source0: http://cpan.org.ua/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This is a the DBIx::Class::Schema manpage component that provides an enhanced version.of the builtin method the populate entry in the DBIx::Class::Schema manpage.  What it does is make it 
easier when you are doing a first time setup and need to insert a bunch of 
rows, like the first time you deploy a new database, or after you update it.

It's not as full featured as the DBIx::Class::Fixtures manpage but is targeted more 
directly at making it easier to just take a prewritten perl structure --or one 
loaded from a configuration file-- and setup your database.

Most of us using the DBIx::CLass manpage have written a version of this at one time or
another.  What is special to this component is the fact that unlike the normal
populate method you can insert to multiple result_sources in one go.  While 
doing this, we index the created rows so as to make it easy to reference them
in relationships. I did this because I think it's very ugly to have to type in 
all the primary keys by hand, particularly if your PK is multi column, or is
using some lengthy format such as uuid.  Also, we can embed expansion commands
in the row values to do inflation for us.  For example, any value starting with
"!Index:" will substitute it's value for that of the relating fields in the 
named row.

This distribution supplies three expansion commands:

=over 4

=item Index

Use for creating relationships.  This is a string in the form of "Source.Label"
where the Source is the name of the result source that you are creating rows in 
and Label is a key name from from key part of the data hash.

=item Env

Get's it's value from %%ENV.  Typically this will be setup in your shell or at
application runtime.  This is a string in the form of "!Env:MY_ENV_VAR"

=item Date

converts it's value to a the DateTime manpage object.  Will use a various methods to try
and coerce a string, like "today", or "January 6, 1974".  Makes it easier to
insert dates into your database without knowing or caring about the expected
format.  For this to work correctly, you need to use the class component
the DBIx::Class::InflateColumn::DateTime manpage and mark your column data type as 
'datetime' or similar.

=item Find

Used for when you want the value of something that you expect already exists
in the database (but for which you didn't just populatemore for, use 'Index'
for that case.) Use cases for this include lookup style tables, like 'Status'
or 'Gender', 'State', etc. which you may already have installed. This is a
string in the form of '!Find:Source.[key1=val1,key2=val2,...'.

If your find doesn't return a single result, expect an error.

It's trivial to write more; please feel free to post me your contributions.

=back

Please note the when inserting rows, we are actually calling "create_or_update"
on each data item, so this will not be as fast as using $schema->bulk_insert.



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn LICENSE t/var/README Changes
%perl_vendor_privlib/D*

%changelog
