# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Carp/Clan.pm) perl(Class/Inspector.pm) perl(Config.pm) perl(Cwd.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Schema.pm) perl(DBIx/Class/Schema/Loader.pm) perl(Data/Dumper.pm) perl(DateTime.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(Filter/Util/Call.pm) perl(FindBin.pm) perl(LWP/Simple.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Module/Find.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Text/Diff.pm) perl(YAML.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(overload.pm) perl(threads/shared.pm) perl(DBD/SQLite.pm) perl(DateTime/Format/SQLite.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name DBIx-Class-Service
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Aggregate DBIC processes between multiple tables.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Z/ZI/ZIGOROU/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Each service class example:.
  package MySchema::Service::User;
  
  use strict;
  use warnings;
  
  use base qw(DBIx::Class::Service);
  
  sub add_user: Transaction {
    my ($class, $schema, $args) = @_;
    
    my $user_rs = $schema->resultset('User');
    
    my $user = $user_rs->create({
      user_seq => undef,
      user_id => $args->{user_id},
      password_digest => crypt($args->{password}, $args->{user_id}),
    });
    
    $user->create_related('profiles', {
      name => $args->{name},
      nickname => $args->{nickname},
    });
    
    return $user;
  }
  
  sub authenticate: DataSource {
    my ($class, $schema, $user_id, $password) = @_;
    return $schema->resultset('User')->find({ user_id => $user_id, password_digest => crypt($password, $user_id) });
  }
  
  1;

And your schema class:

  package MySchema::Schema;
  
  use strict;
  use warnings;
  
  use base 'DBIx::Class::Schema';
  
  __PACKAGE__->load_classes;
  __PACKAGE__->load_components(qw/ServiceManager/);
  __PACKAGE__->load_services({ 'MySchema::Service' => [qw/
    User
  /] });
  
  1;

Using:

  use MySchema::Schema;

  my $schema = MySchema::Schema->connect($dsn, $dbuser, $dbpass);
  ### note: please see arguments. do not need $schema
  $schema->service('User')->add_user($args);


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
