# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name DBIx-Conn-SQLite
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Shortcut to connect to SQLite database
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/DBIx-Conn-SQLite

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module offers some saving in typing when connecting to a SQLite database
using the DBI manpage, and is particularly handy in one-liners. It automatically
`connect()' and exports the database handle `$dbh' for you.

You often only have to specify the database name in the import argument:

 -MDBIx::Conn::SQLite=mydb

This will result in the following DSN:

 DBI:SQLite:dbname=mydb

If you want to use another variable name other than the default `$dbh' for the
database handle, you can specify this in the second import argument (note the
quoting because otherwise the shell will substitute with shell variable):

 -MDBIx::Conn::SQLite=mydb,'$handle'

Lastly, if you want to supply connection attributes, you can do so in the third
argument and the rest (or second and the rest, if you don't customize database
handle name):

 -MDBIx::Conn::SQLite=mydb,RaiseError,1

=for Pod::Coverage ^(.+)$

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/D*

%changelog
