%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(Config.pm) perl(Curses/UI.pm) perl(DBD/Pg.pm) perl(DBI.pm) perl(DBIx/DBSchema.pm) perl(Data/Stag.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(IO/String.pm) perl(Parse/RecDescent.pm) perl(Shell.pm) perl(Term/ANSIColor.pm) perl(Term/ReadLine.pm) perl(Test.pm) perl(Text/Balanced.pm) perl(XML/Parser/PerlSAX.pm) perl(base.pm) perl(the.pm)
# END SourceDeps(oneline)
%define module_version 0.12
%define module_name DBIx-DBStag
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: DBStag
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SC/SCAIN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is for mapping between relational databases and Stag
objects (Structured Tags - see the Data::Stag manpage). Stag objects can also
be represented as XML. The module has two main uses:

=over

=item Querying

This module can take the results of any SQL query and decompose the
flattened results into a tree data structure which reflects the
foreign keys in the underlying relational schema. It does this by
looking at the SQL query and introspecting the database schema, rather
than requiring metadata or an object model.

In this respect, the module works just like a regular the DBI manpage handle, with
a few extra methods.

Queries can also make use of predefined templates

=item Storing Data

DBStag objects can store any tree-like datastructure (such as XML
documents) into a database using normalized schema that reflects the
structure of the tree being stored. This is done using little or no
metadata.

XML can also be imported, and a relational schema automatically generated.

=back

For a tutorial on using DBStag to build and query relational databases
from XML sources, please see the DBIx::DBStag::Cookbook manpage

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
