# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Config/Any.pm) perl(Cwd.pm) perl(DBD/DBM.pm) perl(DBI.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name DBIx-Factory
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: a simple factory class for DBI database handle
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BA/BAHOOTYPR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
# ... preparing to use ...

  $ cat > /config/base/dir/oracle/xe.yaml
  userid: bahoo
  passwd: typer
  dsn:    dbi:Oracle:XE
  attr:
    RaiseError:  0
    PrintError:  1
    LongReadLen: 2079152

  # ... and in your script ...

  # as a class method
  my $dbh = DBIx::Factory->get_dbh(
      config_base => "/config/base/dir",
      config_file => "oracle/xe.yaml"
  );

  # or simply...
  # (in this case, $ENV{DBIF_BASE} is used as config_base.
  #  if not also defined $ENV{DBIF_BASE}, the argument specified
  #  is assumed as a relative path from your current directory)
  my $dbh = DBIx::Factory->get_dbh("oracle/xe.yaml");

  # you can also specify it as an absolute path from '/'
  # (and config_base is ignored even if it is specified)
  my $dbh = DBIx::Factory->get_dbh("/config/base/dir/oracle/xe.yaml");

  # or you can even do just like DBI::connect
  my $dbh = DBIx::Factory->get_dbh("dbi:Oracle:XE", "bahoo", "typer");

  # as an instance method
  my $factory = DBIx::Factory->new("/config/base/dir");
  my $dbh     = $factory->get_dbh("oracle/xe.yaml");

  # when you set RaiseError attr to 1 in your config file
  my $dbh = eval { $factory->get_dbh("oracle/xe.yaml") };
  die $@ if $@;


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
