%define module_name DBIx-NinjaORM
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Load.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DBIx/Inspector.pm) perl(Data/Dumper.pm) perl(Data/Validate/Type.pm) perl(Digest/SHA1.pm) perl(Log/Any.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Storable.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(Test/Type.pm) perl(Test/Warn.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.1.0
Release: alt1
Summary: Flexible Perl ORM for easy transitions from inline SQL to objects.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/DBIx-NinjaORM

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
the DBIx::NinjaORM manpage was designed with a few goals in mind:

=over 4

=item *

Expand objects with data joined from other tables, to do less queries and
prevent lazy-loading of ancillary information.

=item *

Have a short learning curve.

=item *

Provide advanced caching features and manage cache expiration upon database changes.

=item *

Allow a progressive introduction of a separate Model layer in a legacy codebase.

=back



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE ignore.txt README.md examples
%perl_vendor_privlib/D*

%changelog
