%define module_name DBIx-OnlineDDL
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Load.pm) perl(DBD/SQLite.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(DBI/Const/GetInfoType.pm) perl(DBIx/BatchChunker.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(Data/Perl/Role/Collection/Array.pm) perl(Env.pm) perl(Eval/Reversible.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Import/Into.pm) perl(List/Util.pm) perl(Moo.pm) perl(MooX/StrictConstructor.pm) perl(Path/Class.pm) perl(Path/Class/File.pm) perl(Pod/Coverage/TrustPod.pm) perl(Sub/Util.pm) perl(Term/ProgressBar.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/Bundle/More.pm) perl(Test2/Tools/Compare.pm) perl(Test2/Tools/Exception.pm) perl(Test2/Tools/Explain.pm) perl(Types/Common/Numeric.pm) perl(Types/Standard.pm)
BuildRequires: perl(base.pm) perl(lib.pm) perl(namespace/clean.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.1
Release: alt1
Summary: Run DDL on online databases safely
Group: Development/Perl
License: artistic_2
URL: https://github.com/GrantStreetGroup/DBIx-OnlineDDL

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GS/GSG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is a database utility class for running DDL operations (like `ALTER TABLE') safely
on large tables.  It has a similar scope as the DBIx::BatchChunker manpage, but is designed for
DDL, rather than DML.  It also has a similar function to other utilities like
pt-online-schema-change or
gh-ost, but actually works properly with foreign
keys, and is written as a Perl module to hook directly into a DBI handle.

Like most online schema change tools, this works by creating a new shell table that looks
just like the old table, running the DDL changes (through the the before_triggers entry elsewhere in this document hook),
copying data to the new table, and swapping the tables.  Triggers are created to keep the
data in sync.  See the STEP METHODS entry elsewhere in this document for more information.

The full operation is protected with an undo stack via the Eval::Reversible manpage.
If any step in the process fails, the undo stack is run to return the DB back to normal.

This module uses as many of the DBI info methods as possible, along with ANSI SQL in most
places, to be compatible with multiple RDBMS.  So far, it will work with MySQL or SQLite,
but can be expanded to include more systems with a relatively small amount of code
changes.  (See the DBIx::OnlineDDL::Helper::Base manpage for details.)

DISCLAIMER: You should not rely on this class to magically fix any and all locking
problems the DB might experience just because it's being used.  Thorough testing and
best practices are still required.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES LICENSE README CONTRIBUTING.md examples
%perl_vendor_privlib/D*

%changelog
