%define module_name DBIx-OpenTracing
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(Caller/Hide.pm) perl(DBD/Mem.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/Perl/Role/Collection/Hash.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(List/Util.pm) perl(OpenTracing/GlobalTracer.pm) perl(OpenTracing/Implementation.pm) perl(OpenTracing/Implementation/Test.pm) perl(Package/Constants.pm) perl(SQL/Statement.pm) perl(Scalar/Util.pm) perl(Scope/Context.pm) perl(Syntax/Feature/Maybe.pm) perl(Test/Most.pm) perl(Test/OpenTracing/Integration.pm) perl(Test/PostgreSQL.pm) perl(Test/mysqld.pm) perl(parent.pm) perl(syntax.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.0
Release: alt1
Summary: automatically create OpenTracing spans around DBI queries
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SN/SNEZ/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module overrides the DBI manpage methods to create spans around all queries.
It will also try to extract information like the query SQL and the number
of rows returned. the OpenTracing::GlobalTracer manpage is used to accomplish this,
so make sure you set your tracer there.

Spans created by this module will be named after the the DBI manpage method they
wrap and prefixed with "dbi_", a call to `$dbh-'execute()> would produce
a span called "dbi_execute". Note that the span method name may differ
from the one used in your code, since many methods are simply wrappers
around others. The following tags will be added to each span (if possible)
in accordance with
OpenTracing conventions:

=over 4

=item * db.type - always set to "sql"

=item * db.instance - the database name

=item * db.user - the user associated with the handle (not always available)

=item * db.statement - the query SQL

=item * db.rows - the number of rows affected (not always available)

=item * error - will be set to true if the query failed

=back

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES README.md LICENSE.md
%perl_vendor_privlib/D*

%changelog
