%define module_name DBIx-Raw
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Config/Any.pm) perl(Crypt/Blowfish.pm) perl(Crypt/CBC.pm) perl(Crypt/Mode/CBC/Easy.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Digest/MD5.pm) perl(List/Util.pm) perl(MIME/Base64.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Test/Carp.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Types/Standard.pm) perl(YAML/XS.pm) perl(strictures.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.23
Release: alt1
Summary: Maintain control of SQL queries while still having a layer of abstraction above DBI
Group: Development/Perl
License: perl
URL: https://github.com/srchulo/DBIx-Raw

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SR/SRCHULO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
DBIx::Raw allows you to have complete control over your SQL, while still providing useful functionality so you don't have to deal directly with the DBI manpage.

    use DBIx::Raw;
    my $db = DBIx::Raw->new(dsn => $dsn, user => $user, password => $password);

    #alternatively, use a conf file
    my $db = DBIx::Raw->new(conf => '/path/to/conf.pl');

    #get single values in scalar context
    my $name = $db->raw("SELECT name FROM people WHERE id=1");

    #get multiple values in list context
    my ($name, $age) = $db->raw("SELECT name, age FROM people WHERE id=1");
_
    #or
    my @person = $db->raw("SELECT name, age FROM people WHERE id=1");

    #get hash when using scalar context but requesting multiple values
    my $person = $db->raw("SELECT name, age FROM people where id=1");
    my $name = $person->{name};
    my $age = $person->{age};

    #also get hash in scalar context when selecting multiple values using '*'
    my $person = $db->raw("SELECT * FROM people where id=1");
    my $name = $person->{name};
    my $age = $person->{age};

    #insert a record
    $db->raw("INSERT INTO people (name, age) VALUES ('Sally', 26)");

    #insert a record with bind values to help prevent SQL injection
    $db->raw("INSERT INTO people (name, age) VALUES (?, ?)", 'Sally', 26);

    #update records
    $db->raw("UPDATE people SET name='Joe',age=34 WHERE id=1");

    #use bind values to help prevent SQL injection
    $db->raw("UPDATE people SET name=?,age=? WHERE id=?", 'Joe', 34, 1);

    #also use bind values when selecting
    my $name = $db->raw("SELECT name FROM people WHERE id=?", 1);

    #get multiple records as an array of hashes
    my $people = $db->aoh("SELECT name, age FROM people");
    
    for my $person (@$people) { 
        print "$person->{name} is $person->{age} years old\n";
    }

    #update a record easily with a hash
    my %%update = ( 
        name => 'Joe',
        age => 34,
    );

    #record with id=1 now has name=Joe an age=34
    $db->update(href=>\%%update, table => 'people', id=>1);

    #use alternate syntax to encrypt and decrypt data
    $db->raw(query => "UPDATE people SET name=? WHERE id=1", vals => ['Joe'], encrypt => [0]);

    my $decrypted_name = $db->raw(query => "SELECT name FROM people WHERE id=1", decrypt => [0]);

    #when being returned a hash, use names of field for decryption
    my $decrypted_person = $db->raw(query => "SELECT name, age FROM people WHERE id=1", decrypt => ['name']);
    my $decrypted_name = $decrypted_person->{name};



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE todos.md ignore.txt Changes README
%perl_vendor_privlib/D*

%changelog
