# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(DBD/SQLite.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Text/ParseWords.pm) perl(overload.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 DBIx-Recordset
%define upstream_version 0.26

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:	Perl extension for DBI recordsets
License:	GPL+ or Artistic
Group:		Development/Perl
Url:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/modules/by-module/DBIx/%{upstream_name}-%{upstream_version}.tar.bz2

BuildRequires:	perl(DBI.pm)
BuildRequires:  perl(DBD/Pg.pm)
BuildArch:	noarch

Requires:	perl-DBI perl
Requires:	perl-base
Source44: import.info
Patch33: DBIx-Recordset-0.26-defined-hash.patch

%description
DBIx::Recordset is a perl module for abstraction and simplification of database
access.

The goal is to make standard database access (select/insert/update/delete)
easier to handle and independent of the underlying DBMS. Special attention is
made on web applications to make it possible to handle the state-less access
and to process the posted data of formfields, but DBIx::Recordset is not
limited to web applications.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
%patch33 -p1

%build
chmod 644 Changes Recordset.pm
perl -pi -e 's/\cM//' Changes
perl Makefile.PL INSTALLDIRS=vendor << EOF




EOF
make

%install
%makeinstall_std

%files
%doc Changes README TODO
%{perl_vendor_privlib}/DBIx


%changelog
