%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBI.pm) perl(Params/Validate.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name DBIx-Timeout
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: provides safe timeouts for DBI calls
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SAMTREGAR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides a safe method of timing out DBI requests.  An
unsafe method is described in the DBI docs:

   http://search.cpan.org/~timb/DBI/DBI.pm#Signal_Handling_and_Canceling_Operations

The problem with using POSIX sigaction() (the method described above)
is that it relies on unsafe signals to work.  Unsafe signals are well
known to cause instability.  To understand why, imagine the DB client
code is in the middle of updating some global state when the signal
arrives.  That global state could be left in an inconsitent state,
just waiting for the next time it is needed to cause problems.  Since
this will likely occur far from the cause, and only occur rarely, it
can be a very difficult problem to track down.

Instead, this module:

  - Forks a child process which sleeps for $timeout seconds.

  - Runs your long-running query in the parent process.

  - If the parent process finishes first it kills the child and
    returns.

  - If the child process wakes up it kills the parent's DB thread and
    exits with a code so the parent knows it was timed out.

NOTE: After this call your database connection may be killed even
if no timeout occurred.  This is due to a race condition - the child
may wake up just as parent process finishes.  Patches addressing this
bug are welcome.  Until this is fixed you should be ready to reconnect
after call_with_timeout().


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
