# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(DBI/Const/GetInfoType.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/Attribute/ENV.pm) perl(MooseX/Object/Pluggable.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(Text/CSV.pm)
# END SourceDeps(oneline)
%define module_version 0.17
%define module_name DBIx-VersionedDDL
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: Upgrade and downgrade database schemas to a specified version.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DH/DHORNE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is a utility that can upgrade or downgrade a schema. 

    use DBIx::VersionedDDL;

    my $sv = DBIx::VersionedDDL->new(
        user => 'scott',
        pass => 'tiger',
        dsn  => 'DBI:Oracle:orcl',
        ddl_dir => '/home/jdoe/ddl'
    );
    
    # Migrate the schema to version 7.
    $sv->migrate(7);
    
or alternatively:

    use DBIx::VersionedDDL;

    my $dbh = DBI->connect('DBI:Oracle:orcl', 'scott', 'tiger');
    
    my $sv = DBIx::VersionedDDL->new(
        dbh     => $dbh,
        ddl_dir => '/home/jdoe/ddl'
    );
    
    # Migrate the schema to version 7.
    $sv->migrate(7);
    
DBIx::VersiondDDL installs a version table (schema_version) in
the schema that stores the current version number of this
schema. The developer or DBA who maintains the schema will place
a series of upgrade and downgrade scripts in a ddl directory.
The scripts will use the following naming convention:

    +-----------------+-------------------+
    | Upgrade Scripts | Downgrade Scripts |
    +-----------------+-------------------+
    | upgrade1.sql    | downgrade1.sql    |
    | upgrade2.sql    | downgrade2.sql    |
    | upgrade3.sql    | downgrade3.sql    |
    | upgrade4.sql    | downgrade4.sql    |
    | ....            | ....              |
    +-----------------+-------------------+

Each downgrade script reverses the changes of the upgrade
script. The scripts to run are determined by the value in the
version table If the current schema is at version 5 and the
administrator wishes to upgrade to version 10, upgrade scripts
6-10 would be run by the utility, and the version table entry
will be incremented at each step.

If the administrator wishes to downgrade to version 6, the
utility will run downgrade scripts 10-7.

This utility expects SQL statements to be separated by
semi-colons by default, but an explicit separator can be
specified.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
