%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Multimethods.pm) perl(DBI.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/FromText.pm) perl(UNIVERSAL.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name DBO
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Database Objects
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AB/ABW/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`DBO' is an object-oriented database abstraction layer.

`DBO' is designed to be flexibly extensible in a number of directions -
adding new operations on the database, adding new kinds of tables or
columns, and applying to new database systems.  All extensions can be
carried out by creating new classes that inherit from the classes `DBO'
defines, and by defining new multimethod instances for those classes.

`DBO' defines three class hierarchies:

=over 4

=item Database operations

An operation on a database is represented by an object belonging to the
class `DBO::Visitor'.  `DBO' provides a number of operations including
`Create', `Insert' and `Select'.

=item Schema elements

The structure of the database is represented by an object belonging to
the class `DBO::Database', which contains a number of tables
represented by `DBO::Table', each of which contains a number of columns
represented by `DBO::Column'.  `DBO' defines many column types,
including `Char', `Text', `Unsigned', `Integer' and `Time'.

Additional features of columns in the schema - such as the values in the
column being restricted to a set of options, or the column being one of
the keys of the table - are represented by wrapping the column with a
`Modifier' class.  `DBO' defines the modifier classes `Key',
`Option' and `ForeignKey'.  Each column object belonging to the
modifier class has a reference to another column object that describes
the underlying type of the column.

(This design allows a `ForeignKey' column to be implemented by a
`Char' or `Integer' or whatever, as the designer wishes, without
needing extra classes `ForeignKey_Char', `ForeignKey_Integer' and so
on.)

=item Database handles

The database itself is represented by an object belong to the class
`DBO::Handle'.  `DBO' defines the class `DBO::Handle::DBI' as a thin
wrapper around `DBI', but the facility is there for `DBO' to be
applied to other kinds of database (or to define more sophisticated
wrappers around `DBI' such as "virtual databases" - views that include
data from more than one database).

=back

The application of an operation to an element of the schema is
represented by a multimethod instance.  DBO uses three multimethods:

=over

=item visit_database($visitor, $database, $handle)

=item visit_table($visitor, $table, $handle)

=item visit_column($visitor, $column, $handle)

=back

When $visitor is the generic visitor `DBO::Visitor', `visit_database'
visits all the tables in the database; `visit_table' visits all the
columns in the table, `visit_column' visits the base column when
$column is a `Modifier' column, and does nothing otherwise.

See the Class::Multimethods manpage for the full details of the multimethod
implementation.



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/D*

%changelog
